/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.integration.jei;

import dev.ftb.extendedexchange.integration.jei.JEIIntegration;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractEXCategory<T>
implements IRecipeCategory<T> {
    private final RecipeType<T> type;
    private final Component localizedName;
    private final IDrawable background;
    private final IDrawable icon;

    protected AbstractEXCategory(RecipeType<T> type, Component localizedName, IDrawable background, IDrawable icon) {
        this.type = type;
        this.localizedName = localizedName;
        this.background = background;
        this.icon = icon;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    public ResourceLocation getUid() {
        return this.type.getUid();
    }

    public Class<? extends T> getRecipeClass() {
        return this.type.getRecipeClass();
    }

    static IGuiHelper guiHelper() {
        return JEIIntegration.jeiHelpers.getGuiHelper();
    }

    List<Component> positionalTooltip(double mouseX, double mouseY, BiPredicate<Double, Double> predicate, String translationKey, Object ... args) {
        return predicate.test(mouseX, mouseY) ? Collections.singletonList(new TranslatableComponent(translationKey, args)) : Collections.emptyList();
    }
}

